;----------------------------------------------------------------------------
;    MODULE NAME:   TryMeWithUserDialog.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.13  $
;          $Date:   08 Dec 2006 17:36:34  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/TryMeWithUserDialog.MM.pvcs  $
;
; DESCRIPTION
; ~~~~~~~~~~~
; Shows how a dialog can be created and some of the related code.
;
; Note that I wouldn't recommended calling your properties "ANSWER?" as I have
; in this code, this was just easier for me which developing the code as the
; dialog has no real use apart from as an example and test code.
; Give your properties meaningful names such as "NAME" and "PASSWORD" etc.
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
;--- Override some MAKEMSI options ------------------------------------------
;----------------------------------------------------------------------------
#define VER_FILENAME.VER                TryMe.Ver      ;;I only want one VER file for all samples!
#define UISAMPLE_DIALOGS_ID_IN_TITLE.D  Y              ;;In developer mode add dialogs ID to the titlebar


;----------------------------------------------------------------------------
;--- Include MAKEMSI support (with my customisations and MSI branding) ------
;----------------------------------------------------------------------------
#include "ME.MMH"


;----------------------------------------------------------------------------
;--- Create INSTALLDIR ------------------------------------------------------
;----------------------------------------------------------------------------
<$DirectoryTree Key="INSTALLDIR" Dir="c:\program files\TryMe (makemsi sample)\<$MAKEMSI_MM_BASENAME>" CHANGE="\" PrimaryFolder="Y">


;----------------------------------------------------------------------------
;--- Create a new dialog ----------------------------------------------------
;----------------------------------------------------------------------------
;---[4Doco-UserDialog]---
;--- Insert after which dialog? (I never have a "UserRegistrationDlg") ------
#ifdef REMOVED_LicenseAgreementDlg          ;;Only exists if the dialog has been removed...
       #define InsertAfter WelcomeDlg
#else
       #define InsertAfter LicenseAgreementDlg
#endif

;--- Actually create the dialog and insert into the UI ----------------------
<$Dialog "Test Dialog #1" INSERT="<$InsertAfter>" Dialog="MyFirstSettingsDialog">
    ;--- Two entry fields with tooltips (one a password field) --------------
    <$DialogEntry Property="ANSWER1" Label="&Name:"     ToolTip="Enter the users name (max 10 characters)"     Max=10 Width=200>
    <$DialogEntry Property="ANSWER2" Label="&Password:" ToolTip="Enter the users password (max 20 characters)" Max=20 Password=Y>
    <$PropertyList "MsiHiddenProperties" Value="ANSWER2">   ;;Should not be logged...

    ;--- Try a "MaskedEdit" type entry field --------------------------------
    <$DialogEntry Property="ANSWER3" Label="IP &Address:" Control=^ME:###.###.###.###^ ToolTip="IP address (4 bytes 0-255)">

    ;--- Try an entry field which is validated via a regular expression -----
    <$DialogEntry Property="ANSWER4" Label=^&Start with "ABC":^ BLANK="Y" MatchRe="^ABC.+$" CASE="?" ToolTip=^Min 4 characters starting with "ABC" (any case)!^>

    ;--- Entry field for an integer in the range 80-90 ----------------------
    <$DialogEntry Property="ANSWER5" Label="Want &Integer 80-90:" Max="2" Width=35 Integer="80 to 90">

    ;--- Add a combo box (user can choose existing or enter their own) ------
    #data 'ComboBox_ANSWER6' 2
        ;--- Define sounds and a test description shown in the pull down ----
        "woof woof"     "Dog"
        "quack quack"   "Duck"
        "bah bah"       "sheep"
        "moo moo"       "cow"
        "meeow meeow"   "cat"
    #data                       ;;Note that we dynamically add a couple of entries in the custom action below
   <$DialogEntry Property="ANSWER6" Label="Choose a sound:" Control="CB">

   ;--- Check Box -----------------------------------------------------------
   <$DialogEntry Property="ANSWER7" Label="Want more Money?:" Control="XB:False|True" ToolTip="A silly question...">

   ;--- A Radio Button ------------------------------------------------------
   #data 'RadioButton_ANSWER8'
         ;--- All buttons on same dialog line (not over 3) ------------------
         'Yes'   'I accept'               '50'  'Got heaps of money have you?'
         'No'    'No way in a fit!'       '75'  'Smart decision...'
         'Maybe' "Maybe, Oh I don't know" '130' 'Oh well not everyone has brains'
   #data
   <$DialogEntry Property="ANSWER8" Label="Buy car for $1,000,000:" Control="RB">
<$/Dialog>


;--- A second dialog --------------------------------------------------------
#define? TRYME_INCLUDES_LISTVIEW        Y       ;;Y/N - Only room for ONE ListBox or ListView!
<$Dialog "Test Dialog #2" INSERT="MyFirstSettingsDialog">
    ;--- A text only line ---------------------------------------------------
    <$DialogEntry Label="Want to remove Existing files?" Control="Text" LabelWidth="300">

    ;--- The radio button ---------------------------------------------------
    #data 'RadioButton_REMOVE_FILES'
           'Yes'   'Yes'  ''    ^Please note that your Data can't be recovered!^
           'No'    'No'   ''    ''
    #data
    <$DialogEntry Property="REMOVE_FILES" Label="" Control="RB" LabelWidth="0">

    ;--- Which control? -----------------------------------------------------
    #if ['<$TRYME_INCLUDES_LISTVIEW $$UPPER>' = 'N']
        ;--- A ListBox ----------------------------------------------------------
        #data 'ListBox_LIST_VALUE' 2
            ;--- Define sounds and a test description shown in the pull down ----
            "One"   "Choose Me #1"
            "Two"   "Choose Me #2"
            "Three" "Choose Me #3"
            "Four"  "Choose Me #4"
            "Five"  "Choose Me #5"
            "Six"   "Choose Me #6"
            "Seven" "Choose Me #7"
            "Eight" "Choose Me #8"
            "Nine"  "Choose Me #9"
        #data
        <$DialogEntry Label="Choose a listbox value:" Control="TEXT">                                     ;;Want label on its own line
        <$DialogEntry Property="LIST_VALUE" Control="LB" LabelWidth="0" Label="Choose a listbox value:">  ;;Re-specify label ONLY for any failed validation message (don't display it here)
    #else
        ;--- A ListView ---------------------------------------------------------
        <$Binary Key="SomeGraphic.ico" "TryMe.ICO">     ;;Obviously in a real application you'd use more than one graphic!
        #data 'ListView_LIST_VALUE' 3
            ;--- Define sounds and a test description shown in the pull down ----
            "One"   "Choose Me #1"     "SomeGraphic.ico"
            "Two"   "Choose Me #2"     "SomeGraphic.ico"
            "Three" "Choose Me #3"     "SomeGraphic.ico"
            "Four"  "Choose Me #4"     "SomeGraphic.ico"
            "Five"  "Choose Me #5"     "SomeGraphic.ico"
            "Six"   "Choose Me #6"     "SomeGraphic.ico"
            "Seven" "Choose Me #7"     "SomeGraphic.ico"
            "Eight" "Choose Me #8"     "SomeGraphic.ico"
            "Nine"  "Choose Me #9"     "SomeGraphic.ico"
        #data
        <$DialogEntry Label="Choose a listview value:" Control="TEXT">                                                 ;;Want label on its own line
        <$DialogEntry Property="LIST_VALUE" Control="LV" Width="120" LabelWidth="0" Label="Choose a listview value:">  ;;Re-specify label ONLY for any failed validation message (don't display it here)
    #endif
<$/Dialog>
;---[4Doco-UserDialog]---


;----------------------------------------------------------------------------
;--- 1. Retain these values
;--- 2. Supply default values for the dialog
;--- 3. None of these default values are validated during silent install
;--- 4. For silent install your MSIEXEC.EXE command line would supply
;---    overrides for these values as required.
;--- 5. Saving these items is vital for Windows Installer "repair" operations.
;----------------------------------------------------------------------------
#define  PersistMe         <$Property {$?} Persist="Y" PersistHow="LOCAL_MACHINE PRODUCT FOREVER">
<$PersistMe "ANSWER1"      VALUE="fred">
<$PersistMe "ANSWER2"      VALUE="password">
<$PersistMe "ANSWER3"      VALUE="">        ;;No default but indicate we wish to persist the value
<$PersistMe "ANSWER4"      VALUE="ABC#">
<$PersistMe "ANSWER5"      VALUE="87">
<$PersistMe "ANSWER6"      VALUE="woof woof">
<$PersistMe "ANSWER7"      VALUE="">
<$PersistMe "ANSWER8"      VALUE="Maybe">
<$PersistMe "REMOVE_FILES" VALUE="No">
<$PersistMe "LIST_VALUE"   VALUE="Six">


;----------------------------------------------------------------------------------------
;--- Now generally you do something with the dialog values (I'll put in the registry) ---
;----------------------------------------------------------------------------------------
#(
   ;--- Define macro to set application options in registry -----------------
   #define RegSetting
   <$Registry
                HKEY="LOCAL_MACHINE"
                 Key="SOFTWARE\<$COMPANY_NAME>\<$ProdInfo.ProductName>"
                Name=`{$#1}`
               Value=`{$Value}`
             KeyPath="{$KeyPath='N'}"         ;;Optional parm (default = N)
       MsiFormatted="NAME,VALUE"
   >
#)
<$Component "RegistryOptions" Create="Y" Directory_="INSTALLDIR">
   ;--- Component Keypath ---------------------------------------------------
   <$RegSetting "Installed - By <$ProdInfo.ProductName> <$ProductVersion>" Value=^[Date] [Time]^ KeyPath="Y">

   ;--- Set many options ----------------------------------------------------
   <$RegSetting "ANSWER1"      Value=^[ANSWER1]^>
   <$RegSetting "ANSWER2"      Value=^[ANSWER2]^>
   <$RegSetting "ANSWER3"      Value=^[ANSWER3]^>
   <$RegSetting "ANSWER4"      Value=^[ANSWER4]^>
   <$RegSetting "ANSWER5"      Value=^[ANSWER5]^>
   <$RegSetting "ANSWER6"      Value=^[ANSWER6]^>
   <$RegSetting "ANSWER7"      Value=^[ANSWER7]^>
   <$RegSetting "ANSWER8"      Value=^[ANSWER8]^>
   <$RegSetting "REMOVE_FILES" Value=^[REMOVE_FILES]^>
   <$RegSetting "LIST_VALUE"   Value=^[LIST_VALUE]^>
<$/Component>


;----------------------------------------------------------------------------
;--- As a debugging aid display the values ----------------------------------
;----------------------------------------------------------------------------
#if ['<$MmMode>' = '<$MMMODE_DEVELOPMENT>']
    ;--- Create the custom action -------------------------------------------
    <$VbsCa Binary="DebugDisplayValues.vbs">
       <$VbsCaEntry "Install">
           #(
                CaMsgBox "I",      ;;NEVER EVER use Msgbox() etc - they prevent a silent install!
                         "DEBUG MESSAGE SHOWING PROPERTY VALUES!" & vbCRLF & vbCRLF &
                         "ANSWER1      = " & session.property("ANSWER1")      & vbCRLF &
                         "ANSWER2      = " & session.property("ANSWER2")      & vbCRLF &
                         "ANSWER3      = " & session.property("ANSWER3")      & vbCRLF &
                         "ANSWER4      = " & session.property("ANSWER4")      & vbCRLF &
                         "ANSWER5      = " & session.property("ANSWER5")      & vbCRLF &
                         "ANSWER6      = " & session.property("ANSWER6")      & vbCRLF &
                         "ANSWER7      = " & session.property("ANSWER7")      & vbCRLF &
                         "ANSWER8      = " & session.property("ANSWER8")      & vbCRLF &
                         "REMOVE_FILES = " & session.property("REMOVE_FILES") & vbCRLF &
                         "LIST_VALUE   = " & session.property("LIST_VALUE")
           #)
       <$/VbsCaEntry>
    <$/VbsCa>

    ;--- Schedule the above custom action code ------------------------------
    <$VbsCaSetup Binary="DebugDisplayValues.vbs" Entry="Install" Deferred=N Seq="InstallValidate-" CONDITION=^<$CONDITION_INSTALL_ONLY>^>
#endif


;---[4Doco.DynamicallyInsertRecordsIntoComboBox]---
;----------------------------------------------------------------------------
;--- Dynamically insert records into a "ComboBox" dialog control ------------
;----------------------------------------------------------------------------
<$VbsCa Binary="AddEntriesToDialogControls.VBS">
   ;--- Initialization ------------------------------------------------------
   const MSIMODIFY_INSERT_TEMPORARY = 7
   dim oInstaller, oDB, oView                     'Some globals
   dim ErrNumb, ErrDesc
   #define SAVE.ERR.DETAILS   ErrNumb = err.number : ErrDesc = err.description
   #define ADD.ERR.DETAILS    vbCRLF & vbCRLF & "Reason 0x" & hex(ErrNumb) & " - " & ErrDesc

   ;--- INSTALL -------------------------------------------------------------
   <$VbsCaEntry "UpdateControls">
       ;--- Extra a binary --------------------------------------------------
       AddEntriesToDialogControls()
   <$/VbsCaEntry>

   <?NewLine><?NewLine>
   '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   sub AddEntriesToDialogControls()
   '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       ;--- We will handle all errors ourselves -----------------------------
       on error resume next
       CaDebug 1, "Updating Dialog Controls as a demo..."

       ;--- Open the database -----------------------------------------------
       CaDebug 0, "Opening the database"
       set oInstaller = session.Installer
       set oDB        = session.Database
       if  err.number <> 0 then
           <$SAVE.ERR.DETAILS>
           on error goto 0
           VbsCaRaiseError "AddEntriesToDialogControls()", "Tried to open the database..." & <$ADD.ERR.DETAILS>
       end if

       ;--- Look for the BINARY ---------------------------------------------
       CaDebug 2, "Opening a view to the ComboBox table"
       set oView = oDB.OpenView("SELECT * FROM `ComboBox`")
       oView.Execute()
       if  err.number <> 0 then
           <$SAVE.ERR.DETAILS>
           on error goto 0
           VbsCaRaiseError "AddEntriesToDialogControls()", "Could not open a view to the ComboBox table..." & <$ADD.ERR.DETAILS>
       end if

       ;--- Add lines (normally in some sort of loop looking at environment) ---
       on error goto 0
       AddComboBoxLine4ANSWER6 30000, "Fish (dynamic)", "Splash"
       AddComboBoxLine4ANSWER6 30001, "Bird (dynamic)", "Tweet Tweet"

       ;--- Finish up -------------------------------------------------------
       on error resume next
       set oView      = Nothing
       set oInstaller = Nothing
       set oDB        = Nothing
   end sub

   <?NewLine><?NewLine>
   '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   sub AddComboBoxLine4ANSWER6(Order, Text, Value)
   '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       ;--- Create a blank record -------------------------------------------
       on error resume next
       CaDebug 0, "Adding control with value: " & Value
       CaDebug 0, "Creating record..."
       dim oRec : set oRec = oInstaller.CreateRecord(4)
       if  err.number <> 0 then
           <$SAVE.ERR.DETAILS>
           on error goto 0
           VbsCaRaiseError "AddComboBoxLine4ANSWER6", "Failed adding blank record" & <$ADD.ERR.DETAILS>
       end if

       ;--- Update the record we just created -------------------------------
       CaDebug 0, "Updating Record..."
       dim Property : Property = "ANSWER6"
       oRec.StringData(1)  = Property
       oRec.IntegerData(2) = Order
       oRec.StringData(3)  = Value
       oRec.StringData(4)  = Text
       if  err.number <> 0 then
           <$SAVE.ERR.DETAILS>
           on error goto 0
           VbsCaRaiseError "AddComboBoxLine4ANSWER6", "Failed updating the record (is Order=" & Order & " valid?)" & <$ADD.ERR.DETAILS>
       end if

       ;--- Insert the record -----------------------------------------------
       CaDebug 0, "Inserting into the view..."
       oView.Modify MSIMODIFY_INSERT_TEMPORARY, oRec
       if  err.number <> 0 then
           <$SAVE.ERR.DETAILS>
           on error goto 0
           VbsCaRaiseError "AddComboBoxLine4ANSWER6", "The record insertion failed" & <$ADD.ERR.DETAILS>
       end if
end sub
<$/VbsCa>
<$VbsCaSetup Binary="AddEntriesToDialogControls.VBS" Entry="UpdateControls" Seq="<-WelcomeDlg" SeqTable="InstallUISequence" Type="Immediate" CONDITION=^<$CONDITION_INSTALL_ONLY>^>
;---[4Doco.DynamicallyInsertRecordsIntoComboBox]---


;--------------------------------------------------------------------------------------
;--- Add dialog related messages (you might wish not to do this or to use a subset) ---
;--------------------------------------------------------------------------------------
<$Table "Error">
    <$Row Error="2803" Message=^Dialog View did not find a record for the dialog [2]^>
    <$Row Error="2804" Message=^On activation of the control [3] on dialog [2] CMsiDialog failed to evaluate the condition [3]^>
    <$Row Error="2805" Message=^2806 - The dialog [2] failed to evaluate the condition [3]^>
    <$Row Error="2807" Message=^The action [2] is not recognized^>
    <$Row Error="2808" Message=^Default button is illdefined on dialog [2]^>
    <$Row Error="2809" Message=^On the dialog [2] the next control pointers do not form a cycle.There is a pointer from [3] to [4], but there is no further pointer^>
    <$Row Error="2810" Message=^On the dialog [2] the next control pointers do not form a cycle.There is a pointer from both [3] and [5] to [4]^>
    <$Row Error="2811" Message=^On dialog [2] control [3] has to take focus, but it is unable to do so^>
    <$Row Error="2812" Message=^The event [2] is not recognized^>
    <$Row Error="2813" Message=^The EndDialog event was called with the argument [2], but the dialog has a parent^>
    <$Row Error="2814" Message=^On the dialog [2] the control [3] names a non-existent control [4] as the next control^>
    <$Row Error="2815" Message=^ControlCondition table has a row without condition for the dialog [2]^>
    <$Row Error="2816" Message=^The EventMapping table refers to an invalid control [4] on dialog [2] for the event [3]^>
    <$Row Error="2817" Message=^The event [2] failed to set the attribute for the control [4] on dialog [3]^>
    <$Row Error="2818" Message=^In the ControlEvent table EndDialog has an unrecognized argument [2]^>
    <$Row Error="2819" Message=^Control [3] on dialog [2] needs a property linked to it^>
    <$Row Error="2820" Message=^Attempted to initialize an already initialized handler^>
    <$Row Error="2821" Message=^Attempted to initialize an already initialized dialog: [2]^>
    <$Row Error="2822" Message=^No other method can be called on dialog [2] untill all the controls are added^>
    <$Row Error="2823" Message=^Attempted to initialize an already initialized control: [3] on dialog [2]^>
    <$Row Error="2824" Message=^The dialog attribute [3] needs a record of at least [2] field(s)^>
    <$Row Error="2825" Message=^The control attribute [3] needs a record of at least [2] field(s)^>
    <$Row Error="2826" Message=^Control [3] on dialog [2] extends beyond the boundaries of the dialog [4] by [5] pixels^>
    <$Row Error="2827" Message=^The button [4] on the radiobutton group [3] on dialog [2] extends beyond the boundaries of the group [5] by [6] pixels^>
    <$Row Error="2828" Message=^Tried to remove control [3] from dialog [2], but the control is not part of the dialog^>
    <$Row Error="2829" Message=^Attempt to use an uninitialized dialog^>
    <$Row Error="2830" Message=^Attempt to use an uninitialized control on dialog [2]^>
    <$Row Error="2831" Message=^The control [3] on dialog [2] does not support [5] the attribute [4]^>
    <$Row Error="2832" Message=^The dialog [2] does not support the attribute [3]^>
    <$Row Error="2833" Message=^Control [4] on dialog [3] ignored the message [2]^>
    <$Row Error="2834" Message=^The next pointers on the dialog [2] do not form a single loop^>
    <$Row Error="2835" Message=^The control [2] was not found on dialog [3]^>
    <$Row Error="2836" Message=^The control [3] on the dialog [2] can not take focus^>
    <$Row Error="2837" Message=^The control [3] on dialog [2] wants the winproc to return [4]^>
    <$Row Error="2838" Message=^The item [2] in the selection table has itself as a parent^>
    <$Row Error="2839" Message=^Setting the property [2] failed^>
    <$Row Error="2840" Message=^Error dialog name mismatch^>
    <$Row Error="2841" Message=^No OK button was found on the error dialog^>
    <$Row Error="2842" Message=^No text field was found on the error dialog^>
    <$Row Error="2843" Message=^The ErrorString attribute is not supported for standard dialogs^>
    <$Row Error="2844" Message=^Can not execute an error dialog if the errorstring is not set^>
    <$Row Error="2845" Message=^The total width of the buttons exceeds the size of the error dialog^>
    <$Row Error="2846" Message=^SetFocus did not find the required control on the error dialog^>
    <$Row Error="2847" Message=^The control [3] on dialog [2] has both the icon and the bitmap style set^>
    <$Row Error="2848" Message=^Tried to set control [3] as the default button on dialog [2], but the control does not exist^>
    <$Row Error="2849" Message=^The control [3] on dialog [2] is of a type, that can not be integer valued^>
    <$Row Error="2850" Message=^Unrecognized volume type^>
    <$Row Error="2851" Message=^The data for the icon [2] is not valid^>
    <$Row Error="2852" Message=^At least one control has to be added to dialog [2] before it is used^>
    <$Row Error="2853" Message=^Dialog [2] is a modeless dialog. The execute method should not be called on it^>
    <$Row Error="2854" Message=^On the dialog [2] the control [3] is designated as first active control, but there is no such control^>
    <$Row Error="2855" Message=^The radiobutton group [3] on dialog [2] has fewer than 2 buttons^>
    <$Row Error="2856" Message=^Creating a second copy of the dialog [2]^>
    <$Row Error="2857" Message=^The directory [2] is mentioned in the selection table but not found^>
    <$Row Error="2858" Message=^The data for the bitmap [2] is not valid^>
    <$Row Error="2859" Message=^Test error message^>
    <$Row Error="2860" Message=^Cancel button is illdefined on dialog [2]^>
    <$Row Error="2861" Message=^The next pointers for the radiobuttons on dialog [2] control [3] do not form a cycle^>
    <$Row Error="2862" Message=^The attributes for the control [3] on dialog [2] do not define a valid icon size. Setting the size to 16^>
    <$Row Error="2863" Message=^The control [3] on dialog [2] needs the icon [4] in size [5]x[5], but that size is not available. Loading the first available size^>
    <$Row Error="2864" Message=^The control [3] on dialog [2] received a browse event, but there is no configurable directory for the present selection. Likely cause: browse button is not authored correctly^>
    <$Row Error="2865" Message=^Control [3] on billboard [2] extends beyond the boundaries of the billboard [4] by [5] pixels^>
    <$Row Error="2866" Message=^The dialog [2] is not allowed to return the argument [3]^>
    <$Row Error="2867" Message=^The error dialog property is not set^>
    <$Row Error="2868" Message=^The error dialog [2] does not have the error style bit set^>
    <$Row Error="2869" Message=^The dialog [2] has the error style bit set, but is not an error dialog^>
    <$Row Error="2870" Message=^The help string [4] for control [3] on dialog [2] does not contain the separator character^>
    <$Row Error="2871" Message=^The [2] table is out of date: [3]^>
    <$Row Error="2872" Message=^The argument of the CheckPath control event on dialog [2] is invalid^>
    <$Row Error="2873" Message=^On the dialog [2] the control [3] has an invalid string length limit: [4]^>
    <$Row Error="2874" Message=^Changing the text font to [2] failed^>
    <$Row Error="2875" Message=^Changing the text color to [2] failed^>
    <$Row Error="2876" Message=^The control [3] on dialog [2] had to truncate the string: [4]^>
    <$Row Error="2877" Message=^The binary data [2] was not found^>
    <$Row Error="2878" Message=^On the dialog [2] the control [3] has a possible value: [4]. This is an invalid or duplicate value.^>
    <$Row Error="2879" Message=^The control [3] on dialog [2] can not parse the mask string: [4]^>
    <$Row Error="2880" Message=^Do not perform the remaining control events.^>
    <$Row Error="2881" Message=^CMsiHandler initialization failed^>
    <$Row Error="2882" Message=^Dialog window class registration failed^>
    <$Row Error="2883" Message=^CreateNewDialog failed for the dialog [2]^>
    <$Row Error="2884" Message=^Failed to create a window for the dialog [2]!^>
    <$Row Error="2885" Message=^Failed to create the control [3] on the dialog [2]^>
    <$Row Error="2886" Message=^Creating the [2] table failed^>
    <$Row Error="2887" Message=^Creating a cursor to the [2] table failed^>
    <$Row Error="2888" Message=^Executing the [2] view failed^>
    <$Row Error="2889" Message=^Creating the window for the control [3] on dialog [2] failed^>
    <$Row Error="2890" Message=^The handler failed in creating an unitialized dialog^>
    <$Row Error="2891" Message=^Failed to destroy window for dialog [2]^>
    <$Row Error="2892" Message=^[2] is an integer only control, [3] is not a valid integer value^>
    <$Row Error="2893" Message=^The control [3] on dialog [2] can accept property values that are at most [5] characters long. The value [4] exceeds this limit, and has been truncated.^>
    <$Row Error="2894" Message=^Loading RichEd20.dll failed. GetLastError() returned: [2]^>
    <$Row Error="2895" Message=^Freeing RichEd20.dll failed. GetLastError() returned: [2]^>
    <$Row Error="2896" Message=^Executing action [2] failed.^>
    <$Row Error="2897" Message=^Failed to create any [2] font on this system.^>
    <$Row Error="2898" Message=^For [2] textstyle, the system created a '[3]' font, in [4] character set.^>
    <$Row Error="2899" Message=^Failed to create [2] textstyle. GetLastError() returned: [3].^>
<$/Table>
